<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class CreateManualUsers extends Seeder
{
    public function run(): void
    {

    
        $users[] =
            [
            'name' => 'Nikxmedia',
            'email' => 'ilhan@nikxmedia.com',
            'password' => Hash::make('ilhannikx_)^8_ilhan'),
            'email_verified_at' => \Carbon\Carbon::now(),
            'created_at' => \Carbon\Carbon::now(),
            'updated_at' => \Carbon\Carbon::now()
            ]
        ;

        foreach ($users as $user) {
            $userExists = User::where('email', $user['email'])->first();
            if (!$userExists) {
                User::create($user);
            }
        }

    }
}
