<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Müşteri Talebi</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: url('https://www.transparenttextures.com/patterns/wood-pattern.png') repeat;
            padding: 30px;
            color: #2f2f2f;
        }

        .email-container {
            max-width: 600px;
            margin: auto;
            background-color: #ffffff;
            border: 1px solid #d4d4d4;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        }

        .header {
            background-color: #4CAF50;
            color: white;
            padding: 20px;
            text-align: center;
        }

        .header h2 {
            margin: 0;
        }

        .content {
            padding: 20px;
        }

        .info-label {
            font-weight: bold;
            color: #333;
        }

        .footer {
            background-color: #f1f1f1;
            text-align: center;
            font-size: 0.9rem;
            padding: 15px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <h2>Yeni Müşteri Talebi</h2>
        </div>

        <div class="content">
            <p><span class="info-label">Paket:</span> {{ $data['full_name'] ?? 'Belirtilmedi' }}</p>
            <p><span class="info-label">Paket:</span> {{ $data['package'] ?? 'Belirtilmedi' }}</p>
            <p><span class="info-label">E-posta:</span> {{ $data['email'] }}</p>
            <p><span class="info-label">Telefon:</span> {{ $data['phone'] ?? 'Belirtilmedi' }}</p>
            <p><span class="info-label">Mesaj:</span><br>{{ $data['message'] }}</p>
        </div>

        <div class="footer">
            Bu mesaj <strong>WoodenErp Info</strong> tarafından otomatik gönderilmiştir. <br>
            {{ config('app.name') }} © {{ date('Y') }}
        </div>
    </div>
</body>
</html>
