<?php

use App\Mail\ContactFormSubmitted;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;
Route::post('/token/create', function (Request $request) {
    $request->validate([
        'password' => 'required',
        'email' => [
            'required',
            'email',
            function ($attribute, $value, $fail) {
                if ($value !== 'ilhan@nikxmedia.com') {
                    $fail('This email is not allowed.');
                }
            },
        ],
    ]);

    if (!Auth::attempt($request->only('email', 'password'))) {
        return response()->json(['message' => 'Invalid login details'], 401);
    }

    $user = Auth::user();
    $token = $user->createToken('api_token')->plainTextToken;

    return response()->json(['user' => $user, 'token' => $token]);
});

Route::post('sendEmail', function (Request $request) {
    Mail::to(env('MAIL_FROM_ADDRESS'))->send(new ContactFormSubmitted($request->all()));
    return response()->json(['status' => true]);
})->middleware('auth:sanctum');
