// scripts/generate-sitemap.js

const fs = require("fs");
const { SitemapStream, streamToPromise } = require("sitemap");

const baseUrl = "https://nikxmedia.com";

const staticPages = [
  "/",
  "/about",
  "/contact",
  "/gallery",
  "/our-team",
  "/services",
];

const dynamicSlugs = [
  "website-designing",
  "website-development",
  "mobile-marketing",
  "digital-marketing",
  "social-marketing",
  "seo-content-writing",
];

const dynamicPages = dynamicSlugs.map((slug) => `/services/${slug}`);

(async () => {
  const sitemap = new SitemapStream({ hostname: baseUrl });

  [...staticPages, ...dynamicPages].forEach((url) => {
    sitemap.write({
      url,
      changefreq: "monthly",
      priority: url === "/" ? 1.0 : 0.8,
    });
  });

  sitemap.end();

  const sitemapOutput = await streamToPromise(sitemap);
  fs.writeFileSync("public/sitemap.xml", sitemapOutput.toString());
})();
