import nodemailer from "nodemailer";

export async function POST(request) {
  try {
    const bodyText = await request.text();
    console.log("Raw body:", bodyText);

    const { fullName, company, email, phone } = JSON.parse(bodyText);

    if (!fullName || !email || !phone) {
      return new Response(
        JSON.stringify({ success: false, error: "Missing information" }),
        { status: 400 }
      );
    }

    
    const port = Number(process.env.MAIL_PORT);
    const encryption = process.env.MAIL_ENCRYPTION?.toLowerCase();
    const secure = encryption === "ssl" || port === 465;

    
    const transporter = nodemailer.createTransport({
      host: process.env.MAIL_HOST,
      port,
      secure,
      auth: {
        user: process.env.MAIL_USERNAME,
        pass: process.env.MAIL_PASSWORD,
      },
      tls: {
        rejectUnauthorized: false,
      },
    });

    const mailOptions = {
      from: `"${process.env.MAIL_FROM_NAME}" <${process.env.MAIL_FROM_ADDRESS}>`,
      to: "support@nikxmedia.com",
      subject: `New Client Information`,
      html: `
        <p><b>Full Name:</b> ${fullName}</p>
        <p><b>Company/Organization:</b> ${company || "-"}</p>
        <p><b>Email:</b> ${email}</p>
        <p><b>Phone:</b> ${phone}</p>
      `,
    };

    await transporter.sendMail(mailOptions);

    return new Response(JSON.stringify({ success: true }), { status: 200 });
  } catch (error) {
    console.error("Error in POST:", error);
    return new Response(
      JSON.stringify({ success: false, error: error.message }),
      { status: 400 }
    );
  }
}
