import Banner from "@/components/common/Banner";
import MailForm from "@/components/ContactPage/MailForm";
import MapDiv from "@/components/ContactPage/MapDiv";

export const metadata = {
  title: "Contact",
  description:
    "Get in touch with Nikx Media for tailored digital marketing solutions, social media strategies and creative services that help your brand grow. We're here to answer your questions, discuss your project, or simply connect.",
  alternates: {
    canonical: "https://nikxmedia.com/contact",
  },
  robots: {
    index: true,
    follow: true,
  },
};

const ContactPage = () => {
  return (
    <>
      <div className="py-0 md:py-12">
        <Banner />
        <MapDiv />
        <MailForm />
      </div>
    </>
  );
};

export default ContactPage;
