import "./globals.css";

import Header from "@/components/common/Header";
import Footer from "@/components/common/Footer";
import CopyRight from "@/components/common/CopyRight";

export const metadata = {
  title: "Nikx Media",
  description:
    "Nikx Media is a creative digital agency offering marketing, design and digital solutions.",
  robots: {
    index: true,
    follow: true,
  },
};

export default function RootLayout({ children }) {
  return (
    <html lang="en">
      <head>
        <meta
          name="keywords"
          content="Nikx Media, digital agency, marketing, web design, creative services, branding, online solutions"
        />
        <meta name="robots" content="index, follow" />
      </head>
      <body>
        <Header />
        <main>{children}</main>
        <Footer />
        <CopyRight />
      </body>
    </html>
  );
}
