import Banner from "@/components/common/Banner";
import Brands from "@/components/HomePage/Brands";
import Services from "@/components/HomePage/Services";
import Team from "@/components/HomePage/Team";
import ServicesOffer from "@/components/ServicesPage/ServicesOffer";

export const metadata = {
  title: "Our Services",
  description:
    "Discover the wide range of creative and digital services offered by Nikx Media, including branding, web design, content production and more.",
  alternates: {
    canonical: "https://nikxmedia.com/services",
  },
  robots: {
    index: true,
    follow: true,
  },
};

const ServicesPage = () => {
  return (
    <>
      <div className="py-0 md:py-12">
        <Banner />
        <Services />
        <Brands />
        <ServicesOffer />
        <Team />
      </div>
    </>
  );
};

export default ServicesPage;
