"use client";

import Image from "next/image";
import Button from "../common/Button/Button";
import { Barlow } from "next/font/google";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

const AboutAgency = () => {
  return (
    <div className={`max-w-6xl mx-auto px-6 mt-15 h-auto ${barlow.className}`}>
      <div className="flex flex-col md:flex-row gap-10 items-center h-full ">
        <div className="flex gap-4 flex-1 h-full">
          <div className="flex flex-col gap-4 h-full">
            <Image
              src="/images/aboutpage/about-4-1.jpg"
              alt="About Nikx Media - creative digital agency"
              width={350}
              height={500}
              className="object-cover shadow-md filter grayscale h-[80%]"
            />
          </div>
          <div>
            <Image
              src="/images/aboutpage/about-4-2.jpg"
              alt="About Nikx Media - creative digital agency"
              width={300}
              height={250}
              className="object-cover shadow-md filter grayscale h-[60%]"
            />
          </div>
        </div>

        <div className="flex-1 h-full flex flex-col gap-6 px-6">
          <Image
            src="/images/black-nikx-logo.png"
            alt="About Nikx Media - creative digital agency, Nikx Logo"
            width={60}
            height={50}
            className="object-contain grayscale max-w-[150px] h-auto"
          />

          <h5 className="text-lg uppercase font-normal mb-2 text-[#717175] tracking-wider">
            about agency
          </h5>
          <h2 className="text-4xl uppercase font-medium mb-2 text-[#171717]">
            Get to know about the Nikx media
          </h2>
          <h3 className="text-xl uppercase font-semibold mb-2 text-[#0480b4]">
            Driving results through creativity and strategy
          </h3>
          <p className="text-[15px] font-medium mb-2 text-[#717175] leading-7">
            Nikx Media is a full-service digital marketing agency focused on
            helping brands grow through strategic content, performance-based ads
            and innovative design. We turn insights into actions — and actions
            into real results.
          </p>
          <div>
            <Button text="Discover More" hrefLink={"/services"} />
          </div>
        </div>
      </div>
    </div>
  );
};

export default AboutAgency;
