"use client";

import Image from "next/image";
import { Manrope } from "next/font/google";
import Button from "../common/Button/Button";

const manrope = Manrope({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

const AboutInnerBanner = () => {
  return (
    <div className={`relative w-full h-[60vh] mt-20 ${manrope.className}`}>
      <Image
        src="/images/team2.jpg"
        alt="Grow With Community - About Team Nikx Media"
        fill
        className="object-cover grayscale"
        priority
      />
      <div className="absolute inset-0 bg-black opacity-50"></div>

      <div className="absolute inset-0 flex flex-col items-center justify-center text-white px-6 md:px-32 text-center ">
        <div className="flex flex-col items-center justify-between gap-6 w-full max-w-6xl p-4">
          <Image
            src="/images/white-nikx-logo.png"
            alt="Grow With Community - About Team Nikx Media, Nikx logo"
            width={80}
            height={50}
            className="mb-6 object-contain"
          />
          <h2 className="text-3xl md:text-5xl uppercase font-semibold leading-tight tracking-wide">
            <span className="block">Grow With Community &</span>
            <span className="block">Experience Endless Possibilities</span>
          </h2>
          <Button text="Discover More" hrefLink={"/services"} />
        </div>
      </div>
    </div>
  );
};

export default AboutInnerBanner;
