"use client";

import Image from "next/image";
import { AiFillLike, AiOutlineTeam } from "react-icons/ai";
import { Manrope, Barlow } from "next/font/google";
import { motion } from "framer-motion";

const manrope = Manrope({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const AgencyBenefits = () => {
  return (
    <div className={`py-16 px-4 md:px-6 ${manrope.className}`}>
      <div className="w-full max-w-[1240px] mx-auto flex flex-col lg:flex-row items-center gap-12 lg:gap-20">
        <motion.div
          initial={{ opacity: 0, x: -80 }}
          whileInView={{ opacity: 1, x: 0 }}
          transition={{ duration: 0.8, ease: "easeOut" }}
          viewport={{ once: true }}
          className="relative w-full max-w-[600px]"
        >
          <Image
            src="/images/nikx.jpg"
            alt="Agency Benefits - About Benefitst Nikx Media"
            width={600}
            height={600}
            className="w-full h-[400px] md:h-[600px] object-cover"
          />

          {/* <div className="hidden md:block absolute bottom-0 left-0 w-[200px] md:w-[600px] shadow-lg">
            <div className="relative">
              <Image
                src="/images/aboutpage/about-4-3.png"
                alt="Overlay"
                width={600}
                height={600}
                className="w-full h-auto object-contain"
              />
              <div className="absolute inset-0 flex flex-col items-center justify-center text-[#161617] text-left p-4 -left-1/2 -bottom-1/2 text-sm md:text-2xl uppercase font-bold tracking-wide leading-tight">
                <TfiCup className="text-xl sm:text-3xl md:text-4xl mb-2" />
                <h4 className="text-[11px] sm:text-sm md:text-3xl font-bold uppercase">
                  Award winning
                </h4>
                <h4 className="text-[11px] sm:text-sm md:text-3xl font-bold uppercase">
                  Top level web <br /> agency
                </h4>
              </div>
            </div>
          </div> */}
        </motion.div>

        <motion.div
          initial={{ opacity: 0, x: 80 }}
          whileInView={{ opacity: 1, x: 0 }}
          transition={{ duration: 0.8, ease: "easeOut" }}
          viewport={{ once: true }}
          className="w-full lg:w-1/2 space-y-6"
        >
          <div className="flex flex-col gap-4">
            <Image
              src="/images/black-nikx-logo.png"
              alt="Agency Benefits - About Benefitst Nikx Media, Nikx Logo"
              width={60}
              height={50}
              className="mb-1"
            />
            <h2
              className={`text-sm md:text-base uppercase font-normal text-[#717175] tracking-tighter ${barlow.className}`}
            >
              Agency Benefits
            </h2>

            <h3
              className={`text-3xl md:text-4xl font-medium text-[#171717] uppercase tracking-tighter leading-snug ${barlow.className}`}
            >
              Why You Should Choose Nikx Media
            </h3>

            <div className="flex flex-col gap-6 pt-4">
              <div className="about-agency-box">
                <div className="about-agency-icon">
                  <AiFillLike />
                </div>
                <div className="about-agency-textbox">
                  <h4 className="about-agency-heading">
                    Trusted by Leading Brands
                  </h4>
                  <span className="about-agency-text">
                    We’ve helped startups and established companies grow their
                    presence online with tailored strategies and proven results.
                  </span>
                </div>
              </div>

              <div className="about-agency-box">
                <div className="about-agency-icon">
                  <AiOutlineTeam />
                </div>
                <div className="about-agency-textbox">
                  <h4 className="about-agency-heading">
                    High-Impact Creative Team
                  </h4>
                  <span className="about-agency-text">
                    Our experienced designers, strategists and marketers work
                    together to deliver high-quality digital solutions that get
                    noticed.
                  </span>
                </div>
              </div>
            </div>
          </div>
        </motion.div>
      </div>
    </div>
  );
};

export default AgencyBenefits;
