"use client";

import Image from "next/image";
import PersonCard from "../common/Card/PersonCard";

const team = [
  {
    name: "Jane Doe",
    title: "Project Manager",
    image: "/images/team/team-1-1.jpg",
  },
  {
    name: "John Smith",
    title: "Senior Developer",
    image: "/images/team/team-1-2.jpg",
  },
  {
    name: "Emily Davis",
    title: "UX Designer",
    image: "/images/team/team-1-3.jpg",
  },
];

const OurTeam = () => {
  return (
    <div className="py-20 px-6 md:px-20 bg-white text-[#161617]">
      <div className="text-center mb-12">
        <Image
          src="/images/nikx-logo-new.png"
          alt="Our Team - About Benefitst Nikx Media"
          width={50}
          height={50}
          className="object-contain grayscale max-w-[150px] h-auto mx-auto mb-5"
        />

        <p className="text-lg uppercase text-[#717175] tracking-wider font-normal">
          Experienced Team
        </p>
        <h2 className="text-3xl uppercase md:text-4xl font-medium text-[#171717] tracking-wider">
          Meet Our People
        </h2>
      </div>

      <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6 px-4 md:px-80">
        {team.map((member, index) => (
          <PersonCard key={index} member={member} />
        ))}
      </div>
    </div>
  );
};

export default OurTeam;
