"use client";
import React, { useState } from "react";
import Button from "../common/Button/Button";
import { toast, ToastContainer } from "react-toastify";

const BasicForm = () => {
  const [formData, setFormData] = useState({
    fullname: "",
    phone: "",
    email: "",
    message: "",
  });

  const handleChange = (e) => {
    const { name, value } = e.target;
    setFormData((prev) => ({ ...prev, [name]: value }));
  };

  const handleSubmit = async (e) => {
    e.preventDefault();

    const payload = {
      ...formData,
      email: process.env.NEXT_PUBLIC_API_EMAIL,
      password: process.env.NEXT_PUBLIC_API_PASSWORD,
    };

    try {
      const tokenRes = await fetch(process.env.NEXT_PUBLIC_API_URL_TOKEN, {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          Accept: "application/json",
        },
        body: JSON.stringify(payload),
      });

      if (!tokenRes.ok) throw new Error("Token request failed");

      const tokenData = await tokenRes.json();
      const token = tokenData.token;

      const mailPayload = { ...formData };

      const mailRes = await fetch(process.env.NEXT_PUBLIC_API_URL_SENDMAIL, {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          Accept: "application/json",
          Authorization: `Bearer ${token}`,
        },
        body: JSON.stringify(mailPayload),
      });

      if (!mailRes.ok) throw new Error("SendMail request failed");

      setFormData({
        fullname: "",
        phone: "",
        email: "",
        message: "",
      });
      toast.success("Message sent successfully!");

      const mailData = await mailRes.json();
      console.log("Mail API response:", mailData);
    } catch (err) {
      console.error("Error:", err);
      toast.error("Message could not be sent. Try again.");
    }
  };

  return (
    <>
      <form onSubmit={handleSubmit} className="space-y-4">
        <input
          type="text"
          name="fullname"
          placeholder="Full Name"
          value={formData.fullname}
          onChange={handleChange}
          className="bg-[#f2f2f6] px-7 py-5 focus:outline-none focus:ring-2 focus:ring-[#0480b4] w-full"
        />

        <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
          <input
            type="tel"
            name="phone"
            placeholder="Phone Number"
            value={formData.phone}
            onChange={handleChange}
            className="bg-[#f2f2f6] px-7 py-5 focus:outline-none focus:ring-2 focus:ring-[#0480b4] w-full"
          />
          <input
            type="email"
            name="email"
            placeholder="Email Address"
            value={formData.email}
            onChange={handleChange}
            className="bg-[#f2f2f6] px-7 py-5 focus:outline-none focus:ring-2 focus:ring-[#0480b4] w-full"
          />
        </div>

        <textarea
          name="message"
          placeholder="Your Message"
          value={formData.message}
          onChange={handleChange}
          className="bg-[#f2f2f6] px-7 py-5 focus:outline-none focus:ring-2 focus:ring-[#0480b4] w-full"
          rows={5}
          maxLength={500}
        ></textarea>

        <div className="flex justify-center">
          <Button text="Send Message" isForm={true} />
        </div>
      </form>
      <ToastContainer position="top-right" autoClose={4000} />
    </>
  );
};

export default BasicForm;
