import { FaMapMarkerAlt, FaPhoneAlt, FaMailBulk } from "react-icons/fa";

const ContactInfo = () => {
  return (
    <div className="flex flex-col md:flex-row gap-6 mb-16 px-4 md:px-20">
      <div className="relative -mt-20 px-6 md:px-10 py-6 w-full md:w-72 bg-[#0480b4] shadow-md flex flex-col items-start shrink-0 gap-4">
        <div className="bg-[#161617] p-3 rounded-full text-[#0480b4] text-xl">
          <FaPhoneAlt />
        </div>
        <h3 className="text-xl uppercase font-semibold mb-1 leading-7">
          Do you still have questions?
        </h3>
        <div className="text-sm text-[#161617] font-semibold">
          <span>Call Anytime</span>
          <p>
            <a href="tel:+17143427339" className="hover:underline">
              CALL NIKX
            </a>
          </p>
        </div>
      </div>

      <div className="flex flex-col md:flex-row flex-1 items-start gap-6">
        <div className="flex items-start gap-4 bg-white p-6 border-b md:border-b-0 md:border-r border-[#717175] flex-1">
          <div className="bg-[#161617] p-3 rounded-full text-[#0480b4] text-xl">
            <FaMailBulk />
          </div>
          <div>
            <h3 className="text-[15px] text-[#717175] uppercase font-semibold tracking-wider">
              Write email
            </h3>
            <a
              href="mailto:support@nikxmedia.com"
              className="text-lg text-[#161617] font-semibold link-hover hover:underline"
            >
              support@nikxmedia.com
            </a>
          </div>
        </div>

        <div className="flex items-start gap-4 bg-white p-6 flex-1 border-b md:border-b-0 border-[#717175]">
          <div className="bg-[#161617] p-3 rounded-full text-[#0480b4] text-xl">
            <FaMapMarkerAlt />
          </div>
          <div>
            <h3 className="text-[15px] text-[#717175] uppercase font-semibold tracking-wider">
              Visit office
            </h3>

            <p className="text-lg text-[#161617] font-semibold leading-relaxed">
                30 N GOULD ST STE N
                SHERIDAN, WY
                82801
            </p>
            <div className="w-full h-[1px] bg-[#161617] mt-2 mb-2"></div>
            <p className="text-lg text-[#161617] font-semibold leading-relaxed">
              Cevizlik, İstanbul Cd. NO: 30 Kat: 4 Daire: 15, 34140
              <br />
              Bakırköy / İstanbul, TR
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default ContactInfo;