"use client";

import { Manrope } from "next/font/google";
import IntakeForm from "./IntakeForm";
import { useState } from "react";
import BasicForm from "./BasicForm";
import "react-toastify/dist/ReactToastify.css";

const manrope = Manrope({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const WebsiteProjectIntakeForm = () => {
  const [activeTab, setActiveTab] = useState("basic");
  return (
    <div className={`max-w-4xl mx-auto pb-10 ${manrope.className} `}>
      {/* Sekmeler */}
      <div className="max-w-4xl mx-auto mt-10">
        <div className="flex border-b border-gray-300 mb-6 justify-around ">
          <button
            onClick={() => setActiveTab("basic")}
            className={`px-6 py-3 font-semibold cursor-pointer ${
              activeTab === "basic"
                ? "border-b-2 border-[#0480b4] text-[#0480b4]"
                : "text-gray-500 hover:text-[#0480b4]"
            }`}
          >
            Contact Form
          </button>
          <button
            onClick={() => setActiveTab("intake")}
            className={`px-6 py-3 font-semibold cursor-pointer ${
              activeTab === "intake"
                ? "border-b-2 border-[#0480b4] text-[#0480b4]"
                : "text-gray-500 hover:text-[#0480b4]"
            }`}
          >
            Website Project Intake Form
          </button>
        </div>

        {/* Aktif form */}
        {activeTab === "basic" ? <BasicForm /> : <IntakeForm />}
      </div>{" "}
    </div>
  );
};

export default WebsiteProjectIntakeForm;
