import { FaMapMarkerAlt, FaPhoneAlt, FaMailBulk } from "react-icons/fa";
import { Manrope } from "next/font/google";
import ContactInfo from "./ContactInfo";

const manrope = Manrope({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

const MapDiv = () => {
  return (
    <div
      className={`w-full px-4 md:px-12 py-6 md:py-12 max-w-[1440px] mx-auto ${manrope.className}`}
    >
        <div className="w-full mb-10">

            <iframe
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2831.1588323355268!2d-106.9549356!3d44.797951600000005!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x5335fabe8182314f%3A0x16eb18eacf1e0aff!2s30%20N%20Gould%20St%20ste%20r%2C%20Sheridan%2C%20WY%2082801%2C%20USA!5e0!3m2!1sen!2str!4v1756903431725!5m2!1sen!2str"
                className="w-full h-[50vh] sm:h-[60vh] filter grayscale z-0"
                style={{border: 0}}
                allowFullScreen
                loading="lazy"
                referrerPolicy="no-referrer-when-downgrade"
            />
        </div>
        <ContactInfo/>
    </div>
  );
};

export default MapDiv;
