"use client";

import Image from "next/image";
import Lightbox from "yet-another-react-lightbox";
import { useState } from "react";
import { FaSearchPlus } from "react-icons/fa";
import "yet-another-react-lightbox/styles.css";

const images = [
  { src: "/images/gallery/img7.webp" },
  { src: "/images/gallery/img8.webp" },
  { src: "/images/gallery/img9.webp" },
  { src: "/images/gallery/img11.webp" },
  { src: "/images/gallery/img12.webp" },
  { src: "/images/gallery/img13.webp" },
  { src: "/images/gallery/img14.webp" },
  { src: "/images/gallery/img15.webp" },
  { src: "/images/gallery/img16.webp" },
  { src: "/images/gallery/img17.webp" },
  { src: "/images/gallery/img19.webp" },
  { src: "/images/gallery/img20.webp" },
];

const Gallery = () => {
  const [open, setOpen] = useState(false);
  const [index, setIndex] = useState(0);

  return (
    <>
      <div className="flex justify-center py-20 px-4">
        <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 max-w-screen-2xl w-full">
          {images.map((img, i) => (
            <div
              key={i}
              className="relative aspect-square w-full cursor-pointer group overflow-hidden"
              onClick={() => {
                setOpen(true);
                setIndex(i);
              }}
            >
              <Image
                src={img.src}
                alt="nikx media, agency, media, website, website development, website designing, wordpress, cms, wp, e-commerce, e-com, digital marketing, social media, marketing, seo, content, hosting, domain, ai"
                fill
                className="object-cover transition-transform duration-500 group-hover:scale-110 "
                sizes="(max-width: 768px) 100vw, 33vw"
                priority
              />
              <div className="absolute top-0 left-0 w-full h-full bg-[#0480b4] translate-y-[-100%] group-hover:translate-y-0 transition-transform duration-500 ease-in-out opacity-90 z-10 flex items-center justify-center">
                <FaSearchPlus
                  size={30}
                  color="#161617"
                  className="hover:scale-125 transition-all duration-700"
                />
              </div>
            </div>
          ))}
        </div>
      </div>

      <Lightbox
        open={open}
        close={() => setOpen(false)}
        index={index}
        slides={images}
      />
    </>
  );
};

export default Gallery;
