"use client";

import { useEffect, useRef, useState } from "react";
import Image from "next/image";
import { MdOutlineSupportAgent } from "react-icons/md";
import { AiFillLike } from "react-icons/ai";
import HomeAboutCard from "../common/Card/HomeAboutCard";
import { Manrope, Barlow } from "next/font/google";
import Button from "../common/Button/Button";
import { FaAward, FaUsers } from "react-icons/fa";

const manrope = Manrope({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const About = () => {
  const containerRef = useRef(null);
  const [offset, setOffset] = useState({ x: 0, y: 0 });
  useEffect(() => {
    const handleMouseMove = (e) => {
      const rect = containerRef.current.getBoundingClientRect();
      const x = ((e.clientX - rect.left) / rect.width - 0.5) * 20;
      const y = ((e.clientY - rect.top) / rect.height - 0.5) * 20;
      setOffset({ x, y });
    };

    const container = containerRef.current;
    container.addEventListener("mousemove", handleMouseMove);

    return () => {
      container.removeEventListener("mousemove", handleMouseMove);
    };
  }, []);
  return (
    <div className={`py-0 md:py-20 px-0 md:px-6 ${manrope.className}`}>
      <div className="w-full max-w-[1240px] px-4 sm:px-6 md:px-10 xl:px-0 mx-auto flex flex-col md:flex-row items-center gap-24">
        <div className="relative w-full max-w-[600px]" ref={containerRef}>
          <Image
            src="/images/gallery/img1.webp"
            alt="About Nikx Media - creative digital agency"
            width={600}
            height={600}
            className="w-full h-[400px] md:h-[600px] object-cover filter grayscale"
          />
          <div
            className="absolute -right-6 top-1/3 -translate-y-1/2 transition-transform duration-100 ease-out pointer-events-none max-md:hidden"
            style={{
              transform: `translate(${offset.x}px, ${offset.y}px)`,
            }}
          >
            <Image
              src="/images/gallery/img20.webp"
              alt="About Nikx Media - creative digital agency"
              width={250}
              height={250}
            />
          </div>

          <div
            className={`absolute -bottom-8 left-1/2 -translate-x-1/2 flex flex-col md:flex-row gap-4 bg-[#0480b4] w-[90%] p-2 rounded-lg shadow-lg ${barlow.className}`}
          >
            <div className="p-4 flex items-center gap-2 group cursor-pointer transition-all">
              <div className="transition-transform duration-600 group-hover:scale-90">
                <FaAward
                  className="text-[36px] md:text-[48px]"
                  color="#161617"
                />
              </div>
              <div>
                <p className="text-3xl md:text-5xl font-bold text-[#161617]">
                  30+
                </p>
                <p className="text-sm md:text-[16px] text-[#161617] uppercase font-medium tracking-wide">
                  Years Experience
                </p>
              </div>
            </div>

            <div className="p-4 flex items-center gap-2 group cursor-pointer transition-all">
              <div className="transition-transform duration-600 group-hover:scale-90">
                <FaUsers
                  className="text-[36px] md:text-[48px]"
                  color="#161617"
                />
              </div>
              <div>
                <p className="text-3xl md:text-5xl font-bold text-[#161617]">
                  28+
                </p>
                <p className="text-sm md:text-[16px] text-[#161617] uppercase font-medium tracking-wide">
                  Experienced Team
                </p>
              </div>
            </div>
          </div>
        </div>
        <div className="w-full md:w-1/2 space-y-6 px-6 ">
          <div className="flex flex-col gap-4 w-full">
            <Image
              src="/images/black-nikx-logo.png"
              alt="About Nikx Media - creative digital agency- nikx media logo"
              width={60}
              height={50}
              className="mb-1"
            />
            <h2
              className={`text-lg uppercase font-normal text-[#717175] tracking-tighter ${barlow.className}`}
            >
              About Agency
            </h2>
            <h3
              className={`text-5xl font-medium text-[#171717] uppercase tracking-tighter leading-14 ${barlow.className}`}
            >
              your creative partner for amazing digital success
            </h3>

            <p className="text-[#717175] font-medium text-sm leading-[30px]">
              Being present on social media isn’t enough — we make sure your
              brand stands out, sparks conversations and builds meaningful
              connections with your audience.
            </p>
          </div>

          <div className="flex flex-col md:flex-row items-center gap-4 w-full">
            <HomeAboutCard
              iconComponent={MdOutlineSupportAgent}
              title="Get free consultation"
              explain="Get personalized advice from our experts to kick-start your digital growth — free of charge."
              link="/contact"
            />
            <HomeAboutCard
              iconComponent={AiFillLike}
              title="High quality projects"
              explain="Each project we craft meets the highest standards in design, performance and user experience."
              link="/services"
            />
          </div>
          <Button text="Discover More" hrefLink={"/about"} />
        </div>
      </div>
    </div>
  );
};

export default About;
