"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import "swiper/css";
import "swiper/css/autoplay";
import { Autoplay } from "swiper/modules";
import Image from "next/image";

const brands = [
  { src: "/images/brands/nist-logo.png", link: "https://nist.com.tr/" },
  { src: "/images/brands/pvh-logo.png", link: "https://pvhusa.com" },
  { src: "/images/brands/Pulse-Final-Logo.png", link: "https://mypulserx.com" },
  { src: "/images/brands/logo-erapan.png", link: "https://erapan.com.tr" },
  { src: "/images/brands/agacsoft-logo.png", link: "https://agacsoft.com" },
  { src: "/images/brands/woodensoft-logo.png", link: "https://woodenerp.com" },
  { src: "/images/brands/bootsoft-logo.png", link: "https://bootsoft.co.uk" },
];

const Brands = () => {
  return (
    <div className="w-full py-8">
      <div className="max-w-7xl mx-auto px-4 mb-6">
        <div className="flex items-center justify-center gap-4">
          <span className="flex-grow h-px bg-gray-300" />
          <h5 className="text-sm uppercase font-semibold text-center whitespace-nowrap text-[#717175] tracking-widest">
            Our Brands
          </h5>
          <span className="flex-grow h-px bg-gray-300" />
        </div>
      </div>

      <div className="max-w-7xl mx-auto px-4">
        <Swiper
          modules={[Autoplay]}
          spaceBetween={30}
          slidesPerView={2}
          autoplay={{ delay: 4000, disableOnInteraction: false }}
          loop={true}
          breakpoints={{
            640: { slidesPerView: 3 },
            768: { slidesPerView: 4 },
            1024: { slidesPerView: 5 },
          }}
        >
          {brands.map(({ src, link }, index) => (
            <SwiperSlide key={index}>
              <a
                href={link}
                target="_blank"
                rel="noopener noreferrer"
                className="flex items-center justify-center h-24 transition duration-300"
              >
                <Image
                  src={src}
                  alt="About Nikx Media - creative digital agency, brands"
                  width={120}
                  height={60}
                />
              </a>
            </SwiperSlide>
          ))}
        </Swiper>
      </div>
    </div>
  );
};

export default Brands;
