"use client";

import { motion } from "framer-motion";
import Button from "../common/Button/Button";
import { Barlow } from "next/font/google";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

const MainTop = () => {
  return (
    <section
      className={`relative h-[75vh] md:h-[103vh] w-full overflow-hidden ${barlow.className}`}
    >
      <video
        autoPlay
        muted
        loop
        playsInline
        className="absolute top-0 left-0 w-full h-full object-cover"
        src="/videos/nikx-media-new-video.mp4"
        type="video/mp4"
      />

      <motion.div
        className="relative z-20 w-full h-full flex flex-col items-start justify-center text-center text-white px-6 md:px-72"
        initial={{ opacity: 0, y: 40 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.8, ease: "easeOut" }}
      >
        <h1 className="text-4xl md:text-[100px] font-bold mb-4 uppercase drop-shadow-lg text-left tracking-wider">
          Creative <br />
          services for <br /> your business
        </h1>
        <p className="text-lg md:text-xl mb-6 drop-shadow-md text-left">
          We are delivering the best services to our customers
        </p>

        <Button text="Discover More" hrefLink={"/services"} />
      </motion.div>
    </section>
  );
};

export default MainTop;
