"use client";

import Image from "next/image";
import { Barlow } from "next/font/google";
import HomeServiceCard from "../common/Card/HomeServiceCard";
import Button from "../common/Button/Button";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const Services = () => {
  return (
    <div
      className={`relative min-h-[90vh] w-full pt-0 md:pt-32 ${barlow.className}`}
    >
      <div className="absolute inset-0">
        <div className="h-[60%] w-full">
          <div
            className="w-full h-full bg-cover bg-center"
            style={{ backgroundImage: "url('/images/home-service-1.jpg')" }}
          />
        </div>

        <div className="h-[20%] w-full bg-white" />
      </div>

      <div className="relative z-10 h-full flex flex-col justify-center items-center text-center px-6 py-12 md:py-0">
        <div className="mb-8 flex flex-col items-center gap-2">
          <Image
            src="/images/black-nikx-logo.png"
            alt="About Nikx Media - creative digital agency - Nikx media logo"
            width={60}
            height={50}
            className="mb-1"
          />
          <h5 className="text-base md:text-lg uppercase tracking-tight text-[#717175] font-normal">
            Our Services
          </h5>
          <h2 className="text-3xl md:text-5xl uppercase font-medium text-[#171717] mt-2 max-w-xl">
            What we offer
          </h2>
        </div>

        <div className="flex flex-wrap justify-around gap-6 max-w-7xl w-full ">
          <HomeServiceCard
            iconSrc="/images/service-1.png"
            title="Website Designing"
            explain="We design stunning, user-focused websites that reflect your brand and leave a lasting impression on every visitor."
            href="/services/website-designing"
          />
          <HomeServiceCard
            iconSrc="/images/service-2.png"
            title="Website Development"
            explain="We build fast, scalable and fully responsive websites using the latest technologies to ensure top performance."
            href="/services/website-development"
          />
          <HomeServiceCard
            iconSrc="/images/service-3.png"
            title="Social Media"
            explain="We craft engaging social media strategies that grow your audience, boost brand awareness and drive real results."
            href="/services/social-media"
          />
          <HomeServiceCard
            iconSrc="/images/service-4.png"
            title="Digital Marketing"
            explain="Boost your online presence with data-driven strategies, social media campaigns and high-converting ad creatives."
            href="/services/digital-marketing"
          />
        </div>

        <div className="flex flex-col md:flex-row justify-center items-center mt-8 gap-4 max-w-4xl px-4">
          <h5 className="text-base md:text-lg uppercase tracking-tight text-[#161617] font-medium text-center md:text-left">
            Digital Agency services built specifically for your business.
          </h5>
          <Button text="Find Your Solution" hrefLink={"/services"} />
        </div>
      </div>
    </div>
  );
};

export default Services;
