"use client";

import Image from "next/image";
import { Barlow } from "next/font/google";
import Button from "../common/Button/Button";
import TeamBottomSection from "./TeamBottomSection";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

const Team = () => {
  return (
    <div className={`h-auto md:h-screen w-full ${barlow.className} `}>
      <div className="relative w-full h-[60vh]">
        <Image
          src="/images/gallery/img4.jpg"
          alt="About Nikx Media - creative digital agency, team member"
          fill
          className="object-cover grayscale"
          priority
        />
        <div className="absolute inset-0 bg-black/60"></div>
        <div className="absolute inset-0 flex flex-col items-center md:items-start justify-center text-white px-6 md:px-32 text-center md:text-left">
          <div className="flex flex-col md:flex-row items-center justify-between gap-6 w-full max-w-6xl p-4">
            <h2 className="text-3xl md:text-5xl uppercase font-semibold leading-tight tracking-wide">
              <span className="block">Grow With Community &</span>
              <span className="block">Experience Endless Possibilities</span>
            </h2>
            <Button text="Discover More" hrefLink={"/services"} />
          </div>

          <div className="w-full max-w-6xl h-[3px] bg-white my-8 md:my-14"></div>

          <div className="flex flex-col md:flex-row items-center gap-4 w-full max-w-6xl">
            <Image
              src="/images/white-nikx-logo.png"
              alt="About Nikx Media - creative digital agency- nikx media logo"
              width={70}
              height={50}
            />
            <p className="text-sm md:text-lg tracking-wide text-white text-center md:text-left">
              Creative agency services built specifically for your business.
            </p>
          </div>
        </div>
      </div>
      <TeamBottomSection />
    </div>
  );
};

export default Team;
