"use client";

import { FaCheck } from "react-icons/fa";
import { Barlow } from "next/font/google";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

const values = [
  {
    title: "We think differently",
    desc: "Innovation is at the core of everything we do — we challenge the ordinary to deliver unique digital solutions that stand out.",
  },
  {
    title: "High quality projects",
    desc: "Every project we deliver meets the highest standards in design, performance and user experience.",
  },
  {
    title: "Expert team members",
    desc: "Our team is made up of skilled professionals with years of experience in design, development and digital marketing.",
  },
];

const TeamBottomSection = () => {
  return (
    <div
      className={`py-16 bg-[#f8f8f8] w-full flex items-center justify-center px-4 sm:px-6 md:px-10 lg:px-20 ${barlow.className}`}
    >
      <div className="w-full max-w-7xl border border-[#e0e0e0] bg-white shadow-xl p-6 sm:p-8 md:p-10">
        <div className="grid grid-cols-1 sm:grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8">
          {values.map((item, i) => (
            <div
              key={i}
              className="flex gap-4 items-start rounded-lg shadow-md p-6 sm:p-8 bg-white hover:shadow-lg transition-shadow duration-300"
            >
              <div className="w-12 h-12 min-w-[48px] flex items-center justify-center bg-[#161617] rounded-full shadow">
                <FaCheck className="text-[#ed1c24] text-sm" />
              </div>

              <div>
                <h3 className="text-base sm:text-lg font-semibold uppercase mb-1 tracking-wide text-[#161617]">
                  {item.title}
                </h3>
                <p className="text-sm sm:text-[15px] font-medium leading-relaxed text-[#717175]">
                  {item.desc}
                </p>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default TeamBottomSection;
