"use client";

import { Barlow } from "next/font/google";
import { FaCheckCircle, FaSmile, FaRedo, FaUsers, FaRegLightbulb } from "react-icons/fa";
import { MdManageHistory } from "react-icons/md";
import { RiFocus3Line } from "react-icons/ri";


const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const data = [
  {
    number: 886,
    label: "Idea",
    icon: <FaRegLightbulb  size={50} color="#0480b4" />,
  },
  {
    number: 601,
    label: "Focusing",
    icon: <RiFocus3Line size={50} color="#0480b4" />,
  },
  {
    number: 960,
    label: "Managing",
    icon: <MdManageHistory  size={50} color="#0480b4" />,
  },
  {
    number: 240,
    label: "Best Result",
    icon: <FaCheckCircle size={50} color="#0480b4" />,
  },
];

const UsWithNumbers = () => {
  return (
    <div className={`flex flex-wrap justify-center gap-8 max-w-7xl mx-auto px-4 py-12 mt-0 md:-mt-20 ${barlow.className}`}>
      {data.map(({ number, label, icon }, idx) => (
        <div
          key={idx}
          className="relative w-64 h-50 rounded-lg border-10 border-[#0c0c0d] bg-transparent flex flex-col items-center justify-center text-center p-6 
            transition-colors duration-1000 hover:bg-[#0480b4] hover:border-[#0480b4] text-[#fff] hover:text-[#0c0c0d]"
        >
          <div
            className="absolute -top-12 left-1/2 transform -translate-x-1/2 w-24 h-24 rounded-full  bg-[#0c0c0d]
              flex items-center justify-center text-gray-700
              transition-colors duration-600 hover:border-[#0c0c0d] hover:bg-[#161617] hover:text-[#0480b4]"
          >
            {icon}
          </div>

          {/* <p className="text-5xl font-medium">{number}</p> */}
          <p className="mt-5 text-2xl uppercase font-medium tracking-wide">
            {label}
          </p>
        </div>
      ))}
    </div>
  );
};

export default UsWithNumbers;
