"use client";

import Image from "next/image";
import { FaSignInAlt } from "react-icons/fa";
import { Barlow } from "next/font/google";
import UsWithNumbers from "./UsWithNumbers";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const WhyChoose = () => {
  return (
    <div
      className={`relative w-full min-h-screen overflow-hidden bg-[#161617]  mt-10 ${barlow.className}`}
    >
      <div className="absolute inset-0 w-full h-full">
        <div className="w-full h-full bg-[url('/images/why-choose-bg-1.png')] bg-no-repeat bg-cover bg-center opacity-40 mix-blend-luminosity" />
      </div>

      <div className="relative w-full min-h-screen flex overflow-visible">
        <div className="relative z-30 flex items-center justify-center px-6 md:px-6 py-24 slide-in-left bg-[#0480b4] w-full md:w-[65%] h-auto md:h-[70vh] -mr-[15%]">
          <div className="absolute right-10 bottom-0 top-10 flex flex-row justify-end gap-7 items-end z-40">
            <div className="w-7 bg-[#161617] h-[75%] opacity-10" />
            <div className="w-7 bg-[#161617] h-[95%] opacity-10" />
          </div>
          <div className="max-w-md w-full space-y-8">
            <div className="space-y-2">
              <div className="flex flex-col gap-2">
                <Image
                  src="/images/black-nikx-logo.png"
                  alt="About Nikx Media - creative digital agency, nikx media logo"
                  width={70}
                  height={50}
                  className="mb-4"
                />
                <p className="text-sm tracking-widest font-medium uppercase">
                  Agency Benefits
                </p>
              </div>

              <h2 className="text-3xl md:text-4xl font-bold uppercase text-[#161617]">
                Why Choose Our Agency?
              </h2>

              <p className="text-[#161617] text-base leading-relaxed mt-7">
                We combine creative thinking with data-driven strategies to help
                brands grow in a fast-changing digital world. From design to
                delivery, we focus on results that matter.
              </p>
            </div>

            <div className="space-y-4">
              {[1, 2].map((_, i) => (
                <div
                  key={i}
                  className="border border-[#161617] px-4 sm:px-6 md:px-10 lg:px-14 py-4 flex flex-col md:flex-row items-start md:items-center gap-4"
                >
                  <FaSignInAlt className="text-3xl sm:text-4xl md:text-5xl text-[#161617]" />
                  <p className="text-[#161617] font-medium text-base sm:text-lg leading-relaxed">
                    {i === 0
                      ? "Tailor-made strategies designed specifically for your brand's goals and audience."
                      : "A committed team that delivers on time, on budget and above expectations."}
                  </p>
                </div>
              ))}
            </div>
          </div>
        </div>

        <div className="relative z-10 hidden md:block h-[85vh] w-[70%]">
          <Image
            src="/images/gallery/img8.webp"
            alt="About Nikx Media - creative digital agency, why choose, benefits, agency"
            fill
            className="object-cover w-full h-full"
          />
        </div>
      </div>
      <UsWithNumbers />
    </div>
  );
};

export default WhyChoose;
