import { Barlow } from "next/font/google";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

const OfferCard = ({ icon: Icon, title }) => {
  return (
    <div
      className={`bg-[#161617] h-56 flex flex-col items-center justify-evenly text-white text-center p-6 rounded-lg shadow-md transition-all duration-800 hover:shadow-2xl group  ${barlow.className}`}
    >
      <Icon className="text-7xl mb-2 transition-all duration-800 group-hover:text-[#0480b4] group-hover:scale-80" />
      <h3 className="text-lg font-medium uppercase transition-colors duration-300 group-hover:text-[#0480b4]">
        {title}
      </h3>
    </div>
  );
};

export default OfferCard;
