"use client";

import Image from "next/image";
import { FaCheckCircle } from "react-icons/fa";
import { Barlow } from "next/font/google";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

const OurBenefits = () => {
  return (
    <div
      className={`flex flex-col md:flex-row items-center gap-10 px-6 py-16 bg-white text-[#161617] ${barlow.className}`}
    >
      <div className="w-96 h-96 relative rounded-full overflow-hidden shadow-lg">
        <Image
          src="/images/services/services-details-benefit-img.jpg"
          alt="About Nikx Media - creative digital agency, why choose, benefits, agency"
          fill
          className="object-cover filter grayscale"
        />
      </div>

      <div className="w-full md:w-1/2 space-y-6">
        <h3 className="text-2xl font-medium text-[#161617] uppercase tracking-tight">
          Our Benefits
        </h3>
        <p className="text-[16px] md:text-lg font-medium text-[#717175] leading-snug">
          Get the Best Digital Marketing from the Pitoon Agency of Excellence
        </p>

        <div className="space-y-4">
          <div className="service-our-benefits-box">
            <FaCheckCircle className="service-our-benefits-icon" />
            <p className="service-our-benefits-text">Cost Effective</p>
          </div>
          <div className="service-our-benefits-box">
            <FaCheckCircle className="service-our-benefits-icon" />
            <p className="service-our-benefits-text">Equal Opportunities</p>
          </div>
          <div className="service-our-benefits-box">
            <FaCheckCircle className="service-our-benefits-icon" />
            <p className="service-our-benefits-text">
              Creates High Brand Awareness
            </p>
          </div>
          <div className="service-our-benefits-box">
            <FaCheckCircle className="service-our-benefits-icon" />
            <p className="service-our-benefits-text">Higher ROI</p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default OurBenefits;
