"use client";

import React from "react";
import Image from "next/image";
import { Barlow } from "next/font/google";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

const ServicesExplains = ({ service }) => {
  return (
    <div>
      <div
        className={`w-full h-[300px] md:h-[400px] relative mb-8 rounded-lg overflow-hidden shadow-md ${barlow.className}`}
      >
        <Image
          src={`/images/services/${service.image}`}
          alt="nikx media, agency, media, website, website development, website designing, wordpress, cms, wp, e-commerce, e-com, digital marketing, social media, marketing, seo, content, hosting, domain, ai"
          fill
          sizes="(max-width: 768px) 100vw, 70vw"
          className="object-cover"
          priority
        />
      </div>

      <h3 className="text-2xl md:text-3xl uppercase font-semibold mb-6 text-[#161617]">
        {service.title}
      </h3>

      <p className="text-[15px] text-[#717175] mb-6 leading-relaxed font-medium">
        {service.firstExplain}
      </p>

      <h4 className="text-xl md:text-2xl uppercase font-semibold mb-6 text-[#0480b4]">
        {service.otherHeading}
      </h4>
      <p className="text-[15px] text-[#717175] leading-relaxed font-medium">
        {service.secondExplain}
      </p>
    </div>
  );
};

export default ServicesExplains;
