"use client";
import Link from "next/link";
import { usePathname } from "next/navigation";
import { Barlow } from "next/font/google";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

const ServicesLinks = ({ services }) => {
  const pathname = usePathname();

  return (
    <div
      className={`shadow border-2 border-[#0480b4] p-8 uppercase ${barlow.className} tracking-tight text-sm font-semibold`}
    >
      <div className="bg-[#0480b4] p-2 mb-1 pl-4">
        <h3 className="mb-4 text-[#161617]">All Services</h3>
      </div>

      <ul className="space-y-2 text-[#717175]">
        {Object.entries(services).map(([key, value]) => {
          const isActive = pathname.startsWith(`/services/${key}`);
          return (
            <li key={key}>
              <Link
                href={`/services/${key}`}
                className={`block px-6 py-4 rounded transition-colors ${
                  isActive
                    ? "bg-[#161617] text-white font-semibold"
                    : "bg-[#f2f2f6] hover:bg-[#161617] hover:text-[#f2f2f6]"
                }`}
              >
                {value.title}
              </Link>
            </li>
          );
        })}
      </ul>
    </div>
  );
};

export default ServicesLinks;
