"use client";

import Image from "next/image";
import { Barlow } from "next/font/google";
import OfferCard from "./OfferCard";
import { MdOutlineDesignServices } from "react-icons/md";
import { AiOutlineAntDesign } from "react-icons/ai";
import { PiStrategy } from "react-icons/pi";
import { BiBookContent } from "react-icons/bi";
import { FaCode } from "react-icons/fa6";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

export const services = [
  {
    icon: PiStrategy,
    title: "Strategy & Marketing",
  },
  {
    icon: AiOutlineAntDesign,
    title: "Visual Graphic Design",
  },
  {
    icon: BiBookContent,
    title: "Content Writing Skills",
  },
  {
    icon: MdOutlineDesignServices,
    title: "UI / UX Creative Design",
  },

  {
    icon: FaCode,
    title: "Web & App Designing",
  },
];

const ServicesOffer = () => {
  return (
    <div
      className={`w-full bg-[#0480b4] py-30 px-6 md:px-20 ${barlow.className}`}
    >
      <div className="flex flex-col md:flex-row justify-between items-start gap-10 max-w-6xl mx-auto">
        <div className="flex flex-col items-start gap-3">
          <Image
            src="/images/black-nikx-logo.png"
            alt=" Nikx Media, Nikx Logo"
            width={60}
            height={50}
          />
          <h5 className="text-lg font-medium uppercase text-[#161617] tracking-wide">
            Our Services
          </h5>
          <h2 className="text-3xl md:text-4xl uppercase font-semibold text-[#171717] tracking-tighter leading-snug">
            what we’re offering to <br /> our customers
          </h2>
        </div>

        <div className="flex flex-col gap-4 max-w-xl">
          <div className="h-[5px] w-full bg-[#161617]"></div>
          <p className="text-[#161617] text-[16px] leading-relaxed tracking-wide font-normal">
            At Nikx Media, we offer a wide range of digital services including
            website design, social media management and performance marketing —
            all tailored to help your brand grow and succeed in the digital age.
          </p>
        </div>
      </div>

      <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-6 mt-16 max-w-6xl mx-auto">
        {services.map((service, index) => (
          <OfferCard key={index} icon={service.icon} title={service.title} />
        ))}
      </div>
    </div>
  );
};

export default ServicesOffer;
