"use client";

import { Barlow } from "next/font/google";
import { TfiCup } from "react-icons/tfi";
import { TbClockCheck } from "react-icons/tb";
import { GoProjectRoadmap } from "react-icons/go";
import { RiTeamLine } from "react-icons/ri";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

const WhyChoose = () => {
  return (
    <section className={`py-16 ${barlow.className}`}>
      <h3 className="text-2xl sm:text-3xl md:text-4xl font-semibold uppercase text-[#161617] mb-12">
        Why Choose
      </h3>

      <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-6 place-items-center">
        <div className="service-why-choose-box">
          <RiTeamLine className="service-why-choose-box-icon" />
          <h3 className="service-why-choose-box-title">Professional team</h3>
        </div>

        <div className="service-why-choose-box">
          <GoProjectRoadmap className="service-why-choose-box-icon" />
          <h3 className="service-why-choose-box-title">High quality projects</h3>
        </div>

        <div className="service-why-choose-box">
          <TbClockCheck className="service-why-choose-box-icon" />
          <h3 className="service-why-choose-box-title">Deliver work on time</h3>
        </div>

        <div className="service-why-choose-box">
          <TfiCup className="service-why-choose-box-icon" />
          <h3 className="service-why-choose-box-title">Award winning agency</h3>
        </div>
      </div>
    </section>
  );
};

export default WhyChoose;
