"use client";

import Link from "next/link";
import React from "react";
import { Barlow } from "next/font/google";
import { usePathname } from "next/navigation";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "600", "700"],
  display: "swap",
});

const Banner = () => {
  const pathname = usePathname();

  const segments = pathname?.split("/")?.filter(Boolean) || [];
  const currentPage =
    segments.length > 0 ? segments[segments.length - 1] : "home";

  const title = currentPage.charAt(0).toUpperCase() + currentPage.slice(1);

  const bannerImages = {
    about: "/images/gallery/img4.webp",
    services: "/images/services-bg.jpg",
    gallery: "/images/page-header-bg.jpg",
    contact: "/images/page-header-bg-about.jpg",
    default: "/images/services-bg.jpg",
  };

  const bgImage = bannerImages[currentPage] || bannerImages.default;

  return (
    <div
      className={`relative h-[50vh] overflow-hidden w-full ${barlow.className}`}
    >
      <div
        className="absolute inset-0 z-[1] opacity-40 mix-blend-luminosity bg-no-repeat bg-top-right bg-auto slide-in-right filter grayscale"
        style={{ backgroundImage: `url(${bgImage})` }}
      />
      {/* <div className="absolute z-[2] left-[120px] top-0 w-full h-full bg-[url('/images/page-header-bg-1-2.png')] bg-no-repeat bg-top bg-auto animate-bounce-slow" /> */}
      {/* <div className="absolute z-[4] left-0 top-[45px] w-full h-full bg-[url('/images/page-header-bg-shape-1.png')] bg-no-repeat bg-left-top bg-auto animate-bounce-slow" /> */}
      <div className="absolute z-[3] left-0 bottom-0 w-full h-full bg-[url('/images/page-header-bg-1-1.png')] bg-no-repeat bg-left-bottom bg-auto" />
      <div className="absolute bottom-6 md:bottom-20 left-6 md:left-56 z-10  text-sm md:text-base">
        <nav className="flex items-center gap-2 text-[#ed1c24] uppercase tracking-wide font-semibold">
          <Link href="/" className="link-hover">
            Home
          </Link>
          <span>/</span>
          <span>{title}</span>
        </nav>
        <h2 className="font-extrabold text-5xl uppercase text-[#fff] tracking-wide">
          {title}
        </h2>
      </div>
    </div>
  );
};

export default Banner;
