import Link from "next/link";
import { motion } from "framer-motion";
import { Barlow } from "next/font/google";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const MotionLink = motion(Link);

const Button = ({ text, hrefLink, isForm }) => {
  if (!isForm) {
    return (
      <MotionLink
        href={hrefLink}
        className="relative inline-block px-12 py-5 font-semibold uppercase overflow-hidden bg-[#0480b4] group"
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ delay: 0.5, duration: 0.8 }}
      >
        <span
          className={`relative z-20 font-bold uppercase text-[16px] tracking-wide transition-colors duration-300 text-[#161617] group-hover:text-[#ed1c24] ${barlow.className}`}
        >
          {text}
        </span>

        <div
          className="absolute bottom-0 left-0 w-full h-full flex z-10 pointer-events-none"
          style={{ transform: "scaleY(-1)" }}
        >
          {[...Array(3)].map((_, i) => (
            <span
              key={i}
              className="w-1/3 h-[0%] bg-[#000] rounded-b-full origin-bottom group-hover:h-[160%] transition-all ease-in-out"
              style={{
                transitionDuration: "500ms",
                transitionDelay: `${i * 200}ms`,
              }}
            ></span>
          ))}
        </div>
      </MotionLink>
    );
  }

  return (
    <motion.button
      type="submit"
      className="relative inline-block px-12 py-5 font-semibold uppercase overflow-hidden bg-[#0480b4] group cursor-pointer"
      initial={{ opacity: 0, y: 20 }}
      animate={{ opacity: 1, y: 0 }}
      transition={{ delay: 0.5, duration: 0.8 }}
    >
      <span
        className={`relative z-20 font-bold uppercase text-[16px] tracking-wide transition-colors duration-300 text-[#161617] group-hover:text-[#ed1c24] ${barlow.className}`}
      >
        {text}
      </span>

      <div
        className="absolute bottom-0 left-0 w-full h-full flex z-10 pointer-events-none"
        style={{ transform: "scaleY(-1)" }}
      >
        {[...Array(3)].map((_, i) => (
          <span
            key={i}
            className="w-1/3 h-[0%] bg-[#161617] rounded-b-full origin-bottom group-hover:h-[160%] transition-all ease-in-out"
            style={{
              transitionDuration: "500ms",
              transitionDelay: `${i * 200}ms`,
            }}
          ></span>
        ))}
      </div>
    </motion.button>
  );
};

export default Button;
