import Link from "next/link";

const HomeAboutCard = ({ title, explain, iconComponent: Icon, link }) => {
  return (
    <Link href={link} className="w-full md:w-[1/2] pt-4 rounded-lg hover:bg-[#f0f0f0] shadow-md hover:shadow-lg transition-shadow duration-300 h-auto md:h-48 block">
      <div className="flex justify-between items-start flex-col h-full">
        <div className="flex flex-row items-center justify-between gap-2 w-full px-4">
          <h3 className="text-black font-semibold text-md uppercase w-[70%]">{title}</h3>
          <div className="w-12 h-12 bg-[#161617] rounded-full flex items-center justify-center shadow-md">
            <Icon size={26} color="#ed1c24" />
          </div>
        </div>

        <div className="flex flex-col items-end p-4">
          <span className="text-[15px] text-[#717175] font-medium">{explain}</span>
        </div>
      </div>
    </Link>
  );
};

export default HomeAboutCard;
