import Image from "next/image";
import Link from "next/link";
import { Manrope } from "next/font/google";

const manrope = Manrope({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const HomeServiceCard = ({ iconSrc, title, explain, href }) => {
  return (
    <div
      className={` relative bg-white shadow-lg p-6 w-66 h-75 md:h-90 flex flex-col items-center justify-center text-center transition-all duration-700 group overflow-hidden ${manrope.className}`}
    >
      <div className="absolute inset-0 opacity-0 group-hover:opacity-100 transition-opacity duration-700 z-0">
        <div className="absolute inset-0 bg-[url('/images/service-1-hover.png')] bg-cover bg-center transition-all duration-700" />

        <div className="absolute inset-0 bg-[#161617] opacity-90 transition-all duration-700" />
      </div>

      <div className="relative z-10">
        <div className="mb-4 relative w-16 h-16 mx-auto">
          <Image
            src={iconSrc}
            alt={title}
            fill
            style={{ objectFit: "contain" }}
          />
        </div>

        <h3 className="text-xl uppercase font-semibold text-[#161617] group-hover:text-[#0480b4] transition-colors duration-700 px-5">
          <Link href={href}>{title}</Link>
        </h3>

        <p className="text-sm text-[#717175] mt-2 transition-colors duration-700">
          {explain}
        </p>
      </div>
    </div>
  );
};

export default HomeServiceCard;
