import Image from "next/image";
import { Barlow } from "next/font/google";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const PersonCard = ({ member }) => {
  return (
    <div className={`relative group p-4 ${barlow.className}`}>
      <div className="absolute top-0 left-0 w-1.5 h-20 bg-[#0480b4]"></div>
      <div className="absolute top-0 left-0 w-20 h-1.5 bg-[#0480b4]"></div>

      <div className="w-full h-96 relative overflow-hidden rounded-xl shadow-lg">
        <Image
          src={member?.image || "/images/team.jpg"}
          alt="Nikx Media Team - Nikx Media Member"
          fill
          className="object-cover"
        />
        <div className="absolute inset-0 bg-black/20 group-hover:bg-black/50 transition-all duration-300" />

        <div className="absolute bottom-4 left-4 -right-5 bg-white/90 backdrop-blur-md rounded-xl shadow-md p-4">
          <h3 className="text-2xl font-medium uppercase tracking-tight text-[#161617]">
            {member?.name}
          </h3>
          <p className="text-[15px] font-medium uppercase text-[#717175] tracking-tight">
            {member?.title}
          </p>
        </div>
      </div>
    </div>
  );
};

export default PersonCard;
