"use client";

import Link from "next/link";
import Image from "next/image";
import { FaMapMarkerAlt, FaPhoneAlt, FaEnvelope } from "react-icons/fa";
import {
  FaXTwitter,
  FaFacebook,
  FaInstagram,
  FaLinkedin,
} from "react-icons/fa6";
import { Barlow } from "next/font/google";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const footerLinks = [
  {
    title: "Kurumsal",
    links: [
      { href: "/about", label: "About" },
      //{ href: "/our-team", label: "Meet Our Team" },
      { href: "/services", label: "What We Offer" },
      { href: "/gallery", label: "Gallery" },
    ],
  },
  {
    title: "Hızlı Erişim",
    links: [
      { href: "/services/website-development", label: "Website Development" },
      { href: "/services/wp-cms-setup", label: "WP / CMS Setup" },
      { href: "/services/digital-marketing", label: "Digital Marketing" },
      { href: "/services/social-media", label: "Social Media" },
    ],
  },
];

const contactInfo = [
  {
    icon: <FaMapMarkerAlt className="mt-1 text-[#ed1c24]" />,
    content: "30 N GOULD ST STE N\n" +
        "SHERIDAN, WY\n" +
        "82801",
    href: null,
  },
  {
    icon: <FaMapMarkerAlt className="mt-1 text-[#ed1c24]" />,
    content:
      "Cevizlik, İstanbul Cd. NO: 30 Kat: 4 Daire: 15, 34140 Bakırköy/İstanbul, TR",
    href: null,
  },
  {
    icon: <FaPhoneAlt className="text-[#ed1c24]" />,
    content: "+1 (714) 342-7339",
    href: "tel:+17143427339",
  },
  {
    icon: <FaEnvelope className="text-[#ed1c24]" />,
    content: "support@nikxmedia.com",
    href: "mailto:support@nikxmedia.com",
  },
];

const socialMediaLinks = [
  { href: "https://x.com", icon: <FaXTwitter />, label: "X Twitter" },
  { href: "https://facebook.com", icon: <FaFacebook />, label: "Facebook" },
  { href: "https://instagram.com", icon: <FaInstagram />, label: "Instagram" },
  { href: "https://linkedin.com", icon: <FaLinkedin />, label: "LinkedIn" },
];

const Footer = () => {
  return (
    <footer
      className={`relative bg-[#161617] text-white py-26 px-6 overflow-hidden ${barlow.className}`}
    >
      <div className="absolute top-0 left-0 right-0 bottom-0 w-full h-full bg-[url('/images/footer-bg-1.png')] bg-no-repeat bg-cover bg-center opacity-5 mix-blend-luminosity pointer-events-none" />

      <div className="relative z-10 max-w-6xl mx-auto flex flex-col md:flex-row items-start justify-between mb-10">
        <div className="flex gap-4 text-[#fff] text-xl">
          {socialMediaLinks.map(({ href, icon, label }) => (
            <Link
              href={href}
              key={label}
              target="_blank"
              className="footer-icon"
              aria-label={label}
            >
              {icon}
            </Link>
          ))}
        </div>
      </div>
      <div className="max-w-6xl mx-auto border-t border-[#717175] my-8"></div>

      <div className="relative z-10 max-w-6xl mx-auto grid grid-cols-1 md:grid-cols-[1fr_1fr_1fr_1.5fr] gap-8 text-sm">
        {footerLinks.map(({ title, links }) => (
          <div key={title}>
            <ul className="space-y-2">
              {links.map(({ href, label }) => (
                <li key={label}>
                  <Link href={href} className="footer-link">
                    {label}
                  </Link>
                </li>
              ))}
            </ul>
          </div>
        ))}

        <div>
          <ul className="space-y-4">
            {contactInfo.map(({ icon, content, href }, idx) => (
              <li key={idx} className="flex items-center gap-3">
                <span className="flex-shrink-0 w-6 h-6">{icon}</span>
                {href ? (
                  <a href={href} className="footer-contact">
                    {content}
                  </a>
                ) : (
                  <span>{content}</span>
                )}
              </li>
            ))}
          </ul>
        </div>
        <div className="mb-4 md:mb-0">
          <Image
            src="/images/white-nikx-logo.png"
            alt="Nikx Media Footer - Nikx Media Logo"
            layout="intrinsic"
            width={140}
            height={70}
          />
        </div>
      </div>
    </footer>
  );
};

export default Footer;
