"use client";

import { usePathname } from "next/navigation";

const GetInTouch = () => {
  const pathname = usePathname();
  const isHome = pathname === "/";

  return (
    <div
      className={`relative z-10 w-[100%] sm:w-[85%] md:w-[75%] mx-auto bg-[#171717] text-[#0480b4] h-[10rem] sm:h-[17rem] flex items-end px-4 sm:px-8 md:px-20 overflow-hidden ${
        isHome ? "-mb-16" : ""
      }`}
    >
      <div className="absolute top-0 left-1/2 -translate-x-1/2 bg-[#0480b4] rounded-br-[80px] sm:rounded-br-[100px] shadow-lg w-[calc(100%+2px)] h-[6rem] sm:h-[13rem] px-0 sm:px-12 md:px-20 py-8 sm:py-12 [clip-path:polygon(0_0,100%_0,calc(100%-100px)_100%,0%_100%)] z-10 text-center sm:text-left">
        <h2 className="text-md sm:text-2xl md:text-[40px] uppercase font-medium text-[#171717] leading-tight">
          Let’s work together. <br />
          Let’s get together!{" "}
        </h2>
      </div>

      <div className="text-xs sm:text-[16px] font-medium mb-4 sm:mb-6 uppercase text-[#646466] tracking-wider text-center sm:text-left">
        OR CALL US TO GET FREE QUOTE:{" "}
        <a
          href="tel:+17143427339"
          className="font-bold text-white tracking-widest transition-colors duration-300 hover:text-[#0480b4] cursor-pointer"
        >
          CALL NIKX
        </a>
      </div>
    </div>
  );
};

export default GetInTouch;
