"use client";

import { useState } from "react";
import { Barlow } from "next/font/google";
import Link from "next/link";
import Image from "next/image";
import {
  FaXTwitter,
  FaFacebook,
  FaInstagram,
  FaLinkedin,
  FaEnvelope,
} from "react-icons/fa6";
import { FaPhoneAlt, FaChevronDown, FaChevronUp } from "react-icons/fa";

import ServicesModalResponsive from "./Modal/ServicesModalResponsive";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const HamburgerMenu = ({ setMenuOpen }) => {
  const [servicesOpen, setServicesOpen] = useState(false);

  return (
    <div
      className={`text-white font-medium ${barlow.className} space-y-6 relative max-h-screen overflow-y-auto px-4 pt-6 pb-10`}
    >
      <div className="flex">
        <Image
          src="/images/white-nikx-logo.png"
          alt="Nikx Media Hamburger Menu - Nikx Media Logo"
          width={60}
          height={50}
          className="object-contain"
        />
      </div>

      <ul className="flex flex-col space-y-4 relative">
        <li className="border-b border-white pb-2">
          <Link
            href="/"
            className="link-nav block !tracking-tight"
            onClick={() => setMenuOpen(false)}
          >
            Home
          </Link>
        </li>
        <li className="border-b border-white pb-2">
          <Link
            href="/about"
            className="link-nav block !tracking-tight"
            onClick={() => setMenuOpen(false)}
          >
            About
          </Link>
        </li>
        {/* <li className="border-b border-white pb-2">
          <Link
            href="/our-team"
            className="link-nav block !tracking-tight"
            onClick={() => setMenuOpen(false)}
          >
            Our Team
          </Link>
        </li> */}

        <li className="border-b border-white pb-2">
          <button
            onClick={() => setServicesOpen(!servicesOpen)}
            className="flex items-center justify-between w-full link-nav !tracking-tight cursor-pointer"
          >
            <span>Services</span>
            {servicesOpen ? (
              <FaChevronUp size={14} />
            ) : (
              <FaChevronDown size={14} />
            )}
          </button>

          {servicesOpen && (
            <ServicesModalResponsive closeMenu={() => setMenuOpen(false)} />
          )}
        </li>

        <li className="border-b border-white pb-2">
          <Link
            href="/gallery"
            className="link-nav block !tracking-tight"
            onClick={() => setMenuOpen(false)}
          >
            Gallery
          </Link>
        </li>
        <li className="border-b border-white pb-2">
          <Link
            href="/contact"
            className="link-nav block !tracking-tight"
            onClick={() => setMenuOpen(false)}
          >
            Contact
          </Link>
        </li>
      </ul>

      <div className="space-y-3 border-white pt-4 text-sm">
        <div className="hamburger-menu-contact flex items-center gap-2">
          <FaEnvelope />
          <a href="mailto:info@example.com">info@example.com</a>
        </div>

        <div className="hamburger-menu-contact flex items-center gap-2">
          <FaPhoneAlt />
          <a href="tel:+17143427339">+1 (714) 342-7339</a>
        </div>

        <div className="flex items-center gap-4 pt-2">
          <a
            href="https://facebook.com"
            target="_blank"
            rel="noopener noreferrer"
          >
            <FaFacebook className="hamburger-menu-icon" />
          </a>
          <a
            href="https://instagram.com"
            target="_blank"
            rel="noopener noreferrer"
          >
            <FaInstagram className="hamburger-menu-icon" />
          </a>
          <a
            href="https://linkedin.com"
            target="_blank"
            rel="noopener noreferrer"
          >
            <FaLinkedin className="hamburger-menu-icon" />
          </a>
          <a href="https://x.com" target="_blank" rel="noopener noreferrer">
            <FaXTwitter className="hamburger-menu-icon" />
          </a>
        </div>
      </div>
    </div>
  );
};

export default HamburgerMenu;
