"use client";

import { useEffect, useState } from "react";
import Link from "next/link";
import Image from "next/image";
import { Barlow } from "next/font/google";
import { FaPhoneVolume, FaWhatsapp } from "react-icons/fa6";
import { FiMenu, FiX } from "react-icons/fi";
import HeaderTop from "./HeaderTop";
import ServicesModal from "./Modal/ServicesModal";
import HamburgerMenu from "./HamburgerMenu";
import { usePathname } from "next/navigation";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const Header = () => {
  const [menuOpen, setMenuOpen] = useState(false);
  const [scrolled, setScrolled] = useState(false);
  const [servicesOpen, setServicesOpen] = useState(false);
  let timeoutId;

  const pathname = usePathname();

  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 50);
    };

    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  return (
    <header
      className={`w-full fixed top-0 left-0 z-50 transition-colors duration-500 
    ${
      pathname === "/"
        ? scrolled
          ? "bg-[#0c0c0d]"
          : "bg-transparent"
        : scrolled
        ? "bg-[#0c0c0d]"
        : "bg-[#161617]"
    }`}
    >
      <HeaderTop />
      <div className="px-4 md:px-16 py-6 flex items-center justify-between">
        <div className="w-28 h-14 relative z-50">
          <Link href="/">
            <Image
              src="/images/white-nikx-logo.png"
              alt="Nikx Media Header - Nikx Media Logo"
              layout="fill"
              objectFit="contain"
            />
          </Link>
        </div>

        <nav className="hidden md:flex space-x-6 text-white font-medium">
          <Link
            href="/"
            className={`link-nav ${
              pathname === "/" ? "link-nav !text-[#0480b4]" : ""
            }`}
          >
            Home
          </Link>
          <Link
            href="/about"
            className={`link-nav ${
              pathname === "/about/" ? "link-nav !text-[#0480b4]" : ""
            }`}
          >
            About
          </Link>
          {/* <Link href="/our-team"             className={`link-nav ${
              pathname === "/our-team" ? "link-nav !text-[#0480b4]" : ""
            }`}>
            Our Team
          </Link> */}

          <div
            className="relative"
            onMouseEnter={() => {
              clearTimeout(timeoutId);
              setServicesOpen(true);
            }}
            onMouseLeave={() => {
              timeoutId = setTimeout(() => setServicesOpen(false), 200);
            }}
          >
            <span
              className={`link-nav cursor-pointer ${
                pathname.startsWith("/services/")
                  ? "link-nav cursor-pointer !text-[#0480b4]"
                  : ""
              }`}
            >
              Services
            </span>
            {servicesOpen && <ServicesModal />}
          </div>
          <Link
            href="/gallery"
            className={`link-nav ${
              pathname === "/gallery/" ? "link-nav !text-[#0480b4]" : ""
            }`}
          >
            Gallery
          </Link>
          <Link
            href="/contact"
            className={`link-nav ${
              pathname === "/contact/" ? "link-nav !text-[#0480b4]" : ""
            }`}
          >
            Contact
          </Link>
        </nav>

        {/* Hamburger Buton (Mobil) */}
        <div className="md:hidden z-50">
          <button onClick={() => setMenuOpen(!menuOpen)}>
            {menuOpen ? (
              <FiX
                size={30}
                className="text-white hover:text-[#0480b4] transition-colors duration-500 cursor-pointer"
              />
            ) : (
              <FiMenu
                size={30}
                className="text-white hover:text-[#0480b4] transition-colors duration-500 cursor-pointer"
              />
            )}
          </button>
        </div>

        <a
          href="https://wa.me/17143427339"
          className="hidden md:flex items-center space-x-2 text-white font-medium tracking-wider"
          target="_blank"
        >
          <div className="bg-[#161617] rounded-full p-2 flex items-center justify-center text-3xl">
            <FaWhatsapp color="#0480b4" />
          </div>
          <span className="hover:text-[#0480b4] transition-all duration-500">
            NIKX WHATSAPP
          </span>
        </a>
      </div>
      <div
        className={`fixed top-0 left-0 h-screen w-80 bg-[#171717]  p-6 transition-transform duration-1000 ease-in-out md:hidden z-50 ${
          menuOpen ? "translate-x-0" : "-translate-x-full"
        }`}
      >
        <HamburgerMenu setMenuOpen={setMenuOpen} />
      </div>
    </header>
  );
};

export default Header;
