import Link from "next/link";
import {
  FaFacebook,
  FaInstagram,
  FaEnvelope,
  FaMapMarkerAlt,
} from "react-icons/fa";
import { FaXTwitter } from "react-icons/fa6";
import { Manrope } from "next/font/google";

const manrope = Manrope({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const HeaderTop = () => {
  return (
    <div
      className={`bg-[#161617] px-20 py-3 hidden md:flex justify-between items-center text-[#646466] text-xs ${manrope.className}`}
    >
      <ul className="flex items-center space-x-10 list-none p-0 m-0">
        <li className="flex items-center space-x-2">
          <FaEnvelope color="#0480b4" size={15} />
          <a
            href="mailto:support@nikxmedia.com"
            className="link-hover hover:text-[#0480b4]"
          >
            support@nikxmedia.com
          </a>
        </li>

        <li className="flex items-center space-x-2">
          <FaMapMarkerAlt color="#0480b4" size={15} />
          <span>30 N GOULD ST STE N SHERIDAN, WY
82801</span>
        </li>
      </ul>

      <div className="flex items-center space-x-4 ">
        <ul className="flex space-x-3 list-none p-0 m-0">
          <li>
            <Link href="#" className="link-hover">
              Help
            </Link>
          </li>
          <li>
            <Link href="mailto:support@nikxmedia.com" className="link-hover">
              Support
            </Link>
          </li>

          <li>
            <Link href="/contact" className="link-hover">
              Contact
            </Link>
          </li>
        </ul>

        <div className="w-[1px] h-6 bg-[#646466] mx-4"></div>

        <ul className="flex space-x-6 list-none p-0 m-0">
          <li>
            <a href="#" className="link-hover">
              <FaFacebook size={16} />
            </a>
          </li>
          <li>
            <a href="#" className="link-hover">
              <FaXTwitter size={16} />
            </a>
          </li>
          <li>
            <a href="#" className="link-hover">
              <FaInstagram size={16} />
            </a>
          </li>
        </ul>
      </div>
    </div>
  );
};

export default HeaderTop;
