import Link from "next/link";

const services = [
  { href: "/services", label: "Services" },
  { href: "/services/website-designing", label: "Website Designing" },
  { href: "/services/website-development", label: "Website Development" },
  { href: "/services/wp-cms-setup", label: "WP / CMS Setup" },
  {
    href: "/services/e-commerce-platform-setup",
    label: "E-Com Platform Setup",
  },
  { href: "/services/digital-marketing", label: "Digital Marketing" },
  { href: "/services/social-media", label: "Social Media" },
  { href: "/services/seo-content-writing", label: "SEO & Content Writing" },
  { href: "/services/hosting-domain-setup", label: "Hosting & Domain" },
  { href: "/services/ai-solutions", label: "AI Solutions" },
];

const ServicesModal = () => {
  return (
    <div className="absolute top-full left-0 mt-2 w-64 bg-white text-[#161617] shadow-2xl z-50 py-4 px-2 ">
      {services.map(({ href, label }) => (
        <Link key={href} href={href} className="services-modal">
          {label}
        </Link>
      ))}
    </div>
  );
};

export default ServicesModal;
