import Link from "next/link";

const services = [
  { href: "/services", label: "Services" },
  { href: "/services/website-designing", label: "Website Designing" },
  { href: "/services/website-development", label: "Website Development" },
  { href: "/services/wp-cms-setup", label: "WP / CMS Setup" },
  {
    href: "/services/e-commerce-platform-setup",
    label: "E-Com Platform Setup",
  },
  { href: "/services/digital-marketing", label: "Digital Marketing" },
  { href: "/services/social-media", label: "Social Media" },
  { href: "/services/seo-content-writing", label: "SEO & Content Writing" },
  { href: "/services/hosting-domain-setup", label: "Hosting & Domain" },
  { href: "/services/ai-solutions", label: "AI Solutions" },
];

const ServicesModalResponsive = ({ closeMenu }) => {
  return (
    <ul className="flex flex-col pl-4 mt-2 space-y-3 text-sm text-white">
      {services.map(({ href, label }) => (
        <li key={href}>
          <Link
            href={href}
            className="link-nav block !tracking-tight"
            onClick={closeMenu}
          >
            {label}
          </Link>
        </li>
      ))}
    </ul>
  );
};

export default ServicesModalResponsive;
