"use client";

import { useEffect } from "react";
import { FiX } from "react-icons/fi";

const SideMenu = ({ isOpen, onClose, children, width = "w-72" }) => {
  useEffect(() => {
    if (isOpen) {
      document.body.style.overflow = "hidden";
    } else {
      document.body.style.overflow = "auto";
    }

    return () => {
      document.body.style.overflow = "auto";
    };
  }, [isOpen]);

  return (
    <div
      className={`fixed top-0 left-0 h-full ${width} bg-[#171717] z-50 transform transition-transform duration-300 ease-in-out ${
        isOpen ? "translate-x-0" : "-translate-x-full"
      } shadow-lg`}
    >
      <div className="flex justify-end p-4">
        <button onClick={onClose}>
          <FiX className="text-white hover:text-[#0480b4]" size={24} />
        </button>
      </div>

      <div className="px-6">{children}</div>
    </div>
  );
};

export default SideMenu;
