"use client";

import PersonCard from "../Card/PersonCard";


const team = [
  {
    name: "John Doe",
    title: "CEO",
    image: "/images/team/team-1-1.jpg",
  },
  {
    name: "Jane Smith",
    title: "Creative Director",
    image: "/images/team/team-1-2.jpg",
  },
  {
    name: "Alice Johnson",
    title: "Marketing Lead",
    image: "/images/team/team-1-3.jpg",
  },
  {
    name: "Bob Brown",
    title: "Senior Developer",
    image: "/images/team/team-1-4.jpg",
  },
  {
    name: "Sara Lee",
    title: "UX Designer",
    image: "/images/team/team-1-5.jpg",
  },
  {
    name: "Tom Hanks",
    title: "Project Manager",
    image: "/images/team/team-1-6.jpg",
  },
];

const OurTeam = () => {
  return (
    <div className="py-20 px-6 md:px-20 bg-white text-[#161617]">

      <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6 px-4 md:px-80">
        {team.map((member, index) => (
          <PersonCard key={index} member={member} />
        ))}
      </div>
    </div>
  );
};

export default OurTeam;
